//Lab 9 : Determine the frequency response specifications from Nyquist plot of system.
//------------------------------------------------------------------
//Problem Statement: Draw the Nyquist plot of the system G=1/s/{s^2+5s+1}.
//Determine the stability margins.
//------------------------------------------------------------------
//------------------------------------------------------------------
// Operating System OSX (Mac) 10.14.6
// Scilab Version 6.1.0
//------------------------------------------------------------------
xdel(winsid()) // close the figure windows
clear; // clear the workspace
clc; // clear the console
//------------------------------------------------------------------
// system representation
s=%s // Laplace operator
s=poly(0,'s');
G=syslin('c',1/s/(s^2+5*s+1))   //System representation G(s)=1/s/(s^2+5s+1)

//----------------------------------------------------------------------

//Nyquist plot with stability margins
show_margins(G,'nyquist')
zoom_rect([-1.5 -1.2 0 1.2])

[Gm,pcw] = g_margin(G)
[Pm,gcw] = p_margin(G)

disp("Gain Margin",Gm,"Phase crossover frequency",pcw)
disp("Phase Margin",Pm,"Gain crossover frequency",gcw)

